/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;

public class TextEncodedStringSizeTerminated
extends AbstractString {
    public TextEncodedStringSizeTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public TextEncodedStringSizeTerminated(TextEncodedStringSizeTerminated object) {
        super(object);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof TextEncodedStringSizeTerminated && super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        ByteBuffer inBuffer;
        logger.finest("Reading from array from offset:" + offset);
        String charSetName = this.getTextEncodingCharSet();
        CharsetDecoder decoder = Charset.forName(charSetName).newDecoder();
        decoder.reset();
        if (TagOptionSingleton.getInstance().isAndroid()) {
            byte[] truncArr = new byte[arr.length - offset];
            System.arraycopy(arr, offset, truncArr, 0, truncArr.length);
            inBuffer = ByteBuffer.wrap(truncArr);
        } else {
            inBuffer = ByteBuffer.wrap(arr, offset, arr.length - offset).slice();
        }
        CharBuffer outBuffer = CharBuffer.allocate(arr.length - offset);
        CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
        if (coderResult.isError()) {
            logger.warning("Decoding error:" + coderResult.toString());
        }
        decoder.flush(outBuffer);
        outBuffer.flip();
        this.value = charSetName.equals("UTF-16") ? outBuffer.toString().replace("\ufeff", "").replace("\ufffe", "") : outBuffer.toString();
        this.setSize(arr.length - offset);
        logger.config("Read SizeTerminatedString:" + this.value + " size:" + this.size);
    }

    private ByteBuffer writeString(CharsetEncoder encoder, String next, int i, int noOfValues) throws CharacterCodingException {
        ByteBuffer bb = i + 1 == noOfValues ? encoder.encode(CharBuffer.wrap(next)) : encoder.encode(CharBuffer.wrap(next + '\u0000'));
        bb.rewind();
        return bb;
    }

    private ByteBuffer writeStringUTF16LEBOM(String next, int i, int noOfValues) throws CharacterCodingException {
        CharsetEncoder encoder = Charset.forName("UTF-16LE").newEncoder();
        ByteBuffer bb = null;
        bb = i + 1 == noOfValues ? encoder.encode(CharBuffer.wrap('\ufeff' + next)) : encoder.encode(CharBuffer.wrap('\ufeff' + next + '\u0000'));
        bb.rewind();
        return bb;
    }

    private ByteBuffer writeStringUTF16BEBOM(String next, int i, int noOfValues) throws CharacterCodingException {
        CharsetEncoder encoder = Charset.forName("UTF-16BE").newEncoder();
        ByteBuffer bb = null;
        bb = i + 1 == noOfValues ? encoder.encode(CharBuffer.wrap('\ufeff' + next)) : encoder.encode(CharBuffer.wrap('\ufeff' + next + '\u0000'));
        bb.rewind();
        return bb;
    }

    private void stripTrailingNull() {
        String stringValue;
        if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && (stringValue = (String)this.value).length() > 0 && stringValue.charAt(stringValue.length() - 1) == '\u0000') {
            stringValue = stringValue.substring(0, stringValue.length() - 1);
            this.value = stringValue;
        }
    }

    private void checkTrailingNull(List<String> values, String stringValue) {
        if (!TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && stringValue.length() > 0 && stringValue.charAt(stringValue.length() - 1) == '\u0000') {
            String lastVal = values.get(values.size() - 1);
            String newLastVal = lastVal + '\u0000';
            values.set(values.size() - 1, newLastVal);
        }
    }

    @Override
    public byte[] writeByteArray() {
        byte[] data;
        try {
            this.stripTrailingNull();
            String stringValue = (String)this.value;
            String charSetName = this.getTextEncodingCharSet();
            String actualCharSet = null;
            if (charSetName.equals("UTF-16")) {
                actualCharSet = TagOptionSingleton.getInstance().isEncodeUTF16BomAsLittleEndian() ? "UTF-16LE" : "UTF-16BE";
            }
            ByteBuffer outputBuffer = ByteBuffer.allocate((stringValue.length() + 3) * 3);
            List<String> values = TextEncodedStringSizeTerminated.splitByNullSeperator(stringValue);
            this.checkTrailingNull(values, stringValue);
            for (int i = 0; i < values.size(); ++i) {
                String next = values.get(i);
                if (actualCharSet != null) {
                    if (actualCharSet.equals("UTF-16LE")) {
                        outputBuffer.put(this.writeStringUTF16LEBOM(next, i, values.size()));
                        continue;
                    }
                    if (!actualCharSet.equals("UTF-16BE")) continue;
                    outputBuffer.put(this.writeStringUTF16BEBOM(next, i, values.size()));
                    continue;
                }
                outputBuffer.put(this.writeString(Charset.forName(charSetName).newEncoder(), next, i, values.size()));
            }
            outputBuffer.flip();
            data = new byte[outputBuffer.limit()];
            outputBuffer.rewind();
            outputBuffer.get(data, 0, outputBuffer.limit());
            this.setSize(data.length);
        }
        catch (CharacterCodingException ce) {
            logger.severe(ce.getMessage());
            throw new RuntimeException(ce);
        }
        return data;
    }

    protected String getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        logger.finest("text encoding:" + textEncoding + " charset:" + charSetName);
        return charSetName;
    }

    public static List<String> splitByNullSeperator(String value) {
        String[] valuesarray = value.split("\\u0000");
        List<String> values = Arrays.asList(valuesarray);
        if (values.size() == 0) {
            values = new ArrayList<String>(1);
            values.add("");
        }
        return values;
    }

    public void addValue(String value) {
        this.setValue(this.value + "\u0000" + value);
    }

    public int getNumberOfValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value).size();
    }

    public String getValueAtIndex(int index) {
        List<String> values = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        return values.get(index);
    }

    public List<String> getValues() {
        return TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
    }

    public String getValueWithoutTrailingNull() {
        List<String> values = TextEncodedStringSizeTerminated.splitByNullSeperator((String)this.value);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < values.size(); ++i) {
            if (i != 0) {
                sb.append("\u0000");
            }
            sb.append(values.get(i));
        }
        return sb.toString();
    }
}

